***Paths*** (put the paths to your folders )
global path "C:\" //data
cd "C:\tenure" //working dir

********************************************************************************
* Individual level analysis
********************************************************************************

* Pass 1: create minimal per-wave individual selections with standardised "weight"
foreach w in a {
    use pidp `w'_hidp a_indinus_xw using "$path/`w'_indresp", clear
    rename a_indinus_xw weight
    keep pidp `w'_hidp weight
    save `w'_ind_sel, replace
}

foreach w in b c d e {
    use pidp `w'_hidp *_indinub_xw using "$path/`w'_indresp", clear
    rename *_indinub_xw weight
    keep pidp `w'_hidp weight
    save `w'_ind_sel, replace
}

foreach w in f g h i j k l m {
    use pidp `w'_hidp *_indinui_xw using "$path/`w'_indresp", clear
    rename *_indinui_xw weight
    keep pidp `w'_hidp weight
    save `w'_ind_sel, replace
}

foreach w in n {
    use pidp `w'_hidp n_inding2_xw using "$path/`w'_indresp", clear
    rename n_inding2_xw weight
    keep pidp `w'_hidp weight
    save `w'_ind_sel, replace
}

* Pass 2: add wave and merge household tenure (once, same code path for all waves)
foreach w in a b c d e f g h i j k l m n {
    use `w'_ind_sel, clear
    gen wave = strpos("abcdefghijklmn","`w'")
    merge m:1 `w'_hidp using "$path/`w'_hhresp", keepusing(*_tenure_dv)
    drop if _merge == 2
    drop _merge
    rename `w'_tenure tenure
    keep pidp weight tenure wave
    save `w'_sel, replace
}


******************************************************
* Stack all waves (individual-based tenure), inspect
******************************************************
use a_sel, clear
foreach w in b c d e f g h i j k l m n {
    append using `w'_sel
}

* Frequency of wave indicator
fre wave

* Decode negative missing codes on tenure to Stata missing
mvdecode tenure, mv(-9/-1)

* Create rented flag: 1 if private renter (6/7), 0 otherwise
gen rented = 0 if tenure != .
replace rented = 1 if tenure == 6 | tenure == 7

* Cross-tab to confirm mapping
tab tenure rented, mis

* Renting share by wave (weighted)
tab wave rented [aw=weight], row

//chart
preserve
    // 0/1 rented
    gen byte rent1 = rented==1 if !missing(rented)

    // % renting (weighted) by wave
    collapse (mean) p_rent=rent1 [aw=weight], by(wave)
    gen pct = 100*p_rent

    // one-decimal labels, e.g. 14.3
    gen str pct_lab = string(round(pct,0.1), "%9.1f")

    // show every wave tick on x-axis (works even if waves are not consecutive)
    levelsof wave, local(waves)

    twoway ///
        (line pct wave, sort lwidth(medthick)) ///
        (scatter pct wave, msymbol(O) msize(medlarge) ///
                 mlabel(pct_lab) mlabposition(12) mlabgap(2)) ///
        , ytitle("% renting") xtitle("Wave") legend(off) ///
          ylabel(0(1)20, angle(horizontal)) ///
          yscale(range(0 20)) ///
          xlabel(`waves') ///
          title("Share renting private by wave - individuals (weighted)")
restore

********************************************************************************
* Alternative approach using hhresp_dv (household-level derived tenure)
********************************************************************************
foreach w in a b c d e f g h i j k l m n {
    * Pull household-level file: id, weights, and tenure derived variable for wave
	use *hidp *_xw* *tenure_dv using "$path/`w'_hhresp", clear

    * Numeric wave index
	gen wave = strpos("abcdefghijklmn","`w'")

    * Remove wave prefix from vars to standardise names across waves
	renpfix `w'_

    * Save compact per-wave selection
	save `w'_hhresp_sel, replace
}

* Stack all waves (household tenure)
use a_hhresp_sel, clear
foreach w in b c d e f g h i j k l m n {
    append using `w'_hhresp_sel
}

* Consolidate weight across waves:
* pick the available one among hhdenus_xw / hhdenub_xw / hhdenui_xw / hhdeng2_xw
gen weight = hhdenus_xw if hhdenus_xw != .
foreach var in hhdenub_xw hhdenui_xw hhdeng2_xw {
    replace weight = `var' if `var' != .
}

* Decode negative missing codes on derived tenure
mvdecode tenure_dv, mv(-9/-1)

* Create rented flag: 1 if private renter (6/7), 0 otherwise
gen rented = 0 if tenure_dv != .
replace rented = 1 if tenure_dv == 6 | tenure_dv == 7

* Cross-tab to confirm mapping
tab tenure_dv rented, mis

* Renting share by wave (weighted)
tab wave rented [aw=weight], row

//chart
preserve
    // 0/1 rented
    gen byte rent1 = rented==1 if !missing(rented)

    // % renting (weighted) by wave
    collapse (mean) p_rent=rent1 [aw=weight], by(wave)
    gen pct = 100*p_rent

    // one-decimal labels, e.g. 14.3
    gen str pct_lab = string(round(pct,0.1), "%9.1f")

    // show every wave tick on x-axis (works even if waves are not consecutive)
    levelsof wave, local(waves)

    twoway ///
        (line pct wave, sort lwidth(medthick)) ///
        (scatter pct wave, msymbol(O) msize(medlarge) ///
                 mlabel(pct_lab) mlabposition(12) mlabgap(2)) ///
        , ytitle("% renting") xtitle("Wave") legend(off) ///
          ylabel(0(1)20, angle(horizontal)) ///
          yscale(range(0 20)) ///
          xlabel(`waves') ///
          title("Share renting private by wave - households (weighted)")
restore


